IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_SAI_CANCELAMENTO]') AND type in (N'P', N'PC'))
	BEGIN
		DROP PROCEDURE [dbo].[P_EST_NF_SAI_CANCELAMENTO]
	END
	
	
GO

CREATE PROCEDURE P_EST_NF_SAI_CANCELAMENTO (@CD_EMP INT, @CD_FILIAL INT, @CD_NF INT)
AS
	BEGIN TRY
		BEGIN TRANSACTION 
		
		DECLARE @CD_MT_CANCEL	INT		
		DECLARE	@CD_USU			INT
		DECLARE @DT_CANCEL		DATETIME
		DECLARE @ST_DENEGADA	INT
		DECLARE	@DT_ATUAL		DATETIME
		
		DECLARE @RS_CD_PROD		INT		
		DECLARE @RS_CD_NT_MOV	INT
		DECLARE @RS_CD_IT		INT
		DECLARE @RS_QT_IT		MONEY
		
		DECLARE @RS_CD_PED		INT 
		DECLARE @RS_CD_NF_ENT	INT
				
		DECLARE @RS_CD_CTR_DEB	INT
		DECLARE @RS_CD_CTR_CRED	INT		
		
		DECLARE @RS_CD_RC_DEB	INT
		DECLARE @RS_CD_PG_CRED	INT
		DECLARE @RS_CD_DP_LANC	INT
		
		DECLARE @RS_SLD_DUP		MONEY
		DECLARE @RS_SLD_BX		MONEY
		
		DECLARE @RS_CD_CRED_FORN	INT
		DECLARE @RS_VLR_NF			MONEY
		DECLARE @VLR_NF				MONEY		
		DECLARE @RS_VLR_CRED		MONEY
		
		
		SET @DT_ATUAL = CONVERT(VARCHAR(10), GETDATE(), 101)
		
		------------------------------------------------------------------------------------------------------------
		PRINT 'Obtendo informacoes sobre quem solicitou o cancelamento'
		------------------------------------------------------------------------------------------------------------
		SELECT 
			@CD_MT_CANCEL	= T.CD_MT_CANCEL,
			@CD_USU			= T.CD_USU,
			@DT_CANCEL		= T.DT_CANCEL,
			@ST_DENEGADA	= T.ST_DENEGADA
		FROM EST_NF_SAI_CANCEL_SOLIC T
		WHERE	T.CD_EMP		= @CD_EMP
				AND T.CD_FILIAL	= @CD_FILIAL
				AND T.CD_NF		= @CD_NF 
				

		------------------------------------------------------------------------------------------------------------
		PRINT 'Marcando a nota fiscal como cancelada'
		------------------------------------------------------------------------------------------------------------
		UPDATE EST_NF_SAI SET 
			STS_NF		= (CASE WHEN @ST_DENEGADA = 1 THEN 3 ELSE 1 END), 
			DT_CANCEL	= ISNULL(@DT_CANCEL,GETDATE()),
			CD_USU		= ISNULL(@CD_USU,1),
			DT_ULT_ALT	= ISNULL(@DT_CANCEL,GETDATE()),
			CD_MT_CANCEL= ISNULL(@CD_MT_CANCEL,0)
		WHERE CD_EMP		= @CD_EMP 
			AND CD_FILIAL	= @CD_FILIAL
			AND CD_NF		= @CD_NF
	


		------------------------------------------------------------------------------------------------------------
		PRINT 'Gravando informacoes do cancelamento/denegacao'
		------------------------------------------------------------------------------------------------------------

IF  NOT EXISTS ( SELECT CD_NF 
				   FROM EST_NF_SAI_CANCEL 
				  WHERE CD_EMP    = @CD_EMP 
				    AND CD_FILIAL = @CD_FILIAL 
					AND CD_NF     = @CD_NF)	
BEGIN 					
		INSERT INTO EST_NF_SAI_CANCEL (CD_EMP, CD_FILIAL, CD_NF, CD_USU, DT_CANCEL, DT_CAD)
							VALUES	  (@CD_EMP, @CD_FILIAL, @CD_NF, ISNULL(@CD_USU,1), ISNULL(@DT_CANCEL,CONVERT(VARCHAR(10), GETDATE(), 101)), @DT_ATUAL)
END;			


		IF @ST_DENEGADA > 0
			BEGIN 
				INSERT INTO EST_NF_SAI_DENEGADA (CD_EMP, CD_FILIAL, CD_NF, DT_DENEGADA, DT_CAD)
									VALUES		(@CD_EMP, @CD_FILIAL, @CD_NF, ISNULL(@DT_CANCEL,CONVERT(VARCHAR(10), GETDATE(), 101)), @DT_ATUAL)
			END

		------------------------------------------------------------------------------------------------------------
		PRINT 'Removendo vinculo com nota fiscal de entrada'
		------------------------------------------------------------------------------------------------------------
		DELETE FROM EST_NF_ENT_NF_SAI
		WHERE	CD_EMP		  = @CD_EMP 
				AND CD_FILIAL = @CD_FILIAL	
				AND CD_NF_SAI = @CD_NF
				
		------------------------------------------------------------------------------------------------------------
		PRINT 'Excluindo relacionamento pre-fatura com a duplicata de convenio'
		------------------------------------------------------------------------------------------------------------		
		DELETE D
		FROM RC_DEB_RC_CONV_EST_PED_VD D
		WHERE EXISTS (SELECT CD_EMP 
					  FROM EST_NF_SAI_PED_VD I
					  WHERE I.CD_EMP		= D.CD_EMP
							AND I.CD_FILIAL	= D.CD_FILIAL
							AND I.CD_PED	= D.CD_PED
							AND I.CD_EMP	= @CD_EMP
							AND I.CD_FILIAL = @CD_FILIAL
							AND I.CD_NF		= @CD_NF)		
		
		------------------------------------------------------------------------------------------------------------
		PRINT 'Excluindo relacionamento  pre-fatura com cupons fiscais'
		------------------------------------------------------------------------------------------------------------					
		DELETE D
		FROM PDV_VD_EST_PED_VD_AGRUPAMENTO D
		WHERE EXISTS (SELECT CD_EMP 
					  FROM EST_NF_SAI_PED_VD I
					  WHERE I.CD_EMP		= D.CD_EMP
							AND I.CD_FILIAL	= D.CD_FILIAL
							AND I.CD_PED	= D.CD_PED
							AND I.CD_EMP	= @CD_EMP
							AND I.CD_FILIAL = @CD_FILIAL
							AND I.CD_NF		= @CD_NF)				
							
							
		------------------------------------------------------------------------------------------------------------
		PRINT 'Voltando o estoque dos itens da nota fiscal'
		------------------------------------------------------------------------------------------------------------					
		DECLARE RS_TEMP_IT CURSOR FAST_FORWARD FOR 
			SELECT
				i.CD_PROD,
				i.QT_IT,
				n.CD_NT_MOV
			FROM
				EST_NF_SAI_IT i INNER JOIN EST_NF_SAI n ON
				i.CD_EMP = n.CD_EMP AND
				i.CD_FILIAL = n.CD_FILIAL AND
				i.CD_NF = n.CD_NF AND
				i.DT_EMI_NF = n.DT_EMI_NF
			WHERE
				i.CD_EMP		= @CD_EMP
				AND i.CD_FILIAL = @CD_FILIAL
				AND i.CD_NF		= @CD_NF

		OPEN RS_TEMP_IT
		FETCH NEXT FROM RS_TEMP_IT INTO @RS_CD_PROD, @RS_QT_IT, @RS_CD_NT_MOV
			WHILE @@FETCH_STATUS=0
				BEGIN			    
					EXEC P_EST_PROD_CPL_ESTOQUE_MOVIMENTACAO @CD_EMP, @CD_FILIAL, @RS_CD_PROD, @RS_CD_NT_MOV, @RS_QT_IT, 1
					
					FETCH NEXT FROM RS_TEMP_IT INTO @RS_CD_PROD, @RS_QT_IT, @RS_CD_NT_MOV
				END
				
		CLOSE RS_TEMP_IT;
		DEALLOCATE RS_TEMP_IT;			

		------------------------------------------------------------------------------------------------------------
		PRINT 'Deletando vinculo da nota fiscal com cupom fiscal'
		------------------------------------------------------------------------------------------------------------	
		DELETE D
		FROM PDV_VD_EST_NF_SAI D
		WHERE 
			CD_EMP			= @CD_EMP
			AND CD_FILIAL	= @CD_FILIAL
			AND CD_NF		= @CD_NF
					
		------------------------------------------------------------------------------------------------------------
		PRINT 'Identificando o pedido e a nota fiscal de entrada relacionado a nota de saida'
		------------------------------------------------------------------------------------------------------------		
		SELECT 
			@RS_CD_PED		= EST_NF_ENT_EST_PED_VD.CD_PED,
			@RS_CD_NF_ENT	= EST_NF_ENT_EST_PED_VD.CD_NF
		FROM EST_NF_ENT_EST_PED_VD 
			INNER JOIN EST_NF_SAI_PED_VD ON 
				EST_NF_ENT_EST_PED_VD.CD_EMP		= EST_NF_SAI_PED_VD.CD_EMP
				AND EST_NF_ENT_EST_PED_VD.CD_FILIAL = EST_NF_SAI_PED_VD.CD_FILIAL 
				AND EST_NF_ENT_EST_PED_VD.CD_PED	= EST_NF_SAI_PED_VD.CD_PED	
		WHERE EST_NF_SAI_PED_VD.CD_EMP		= @CD_EMP 
			AND EST_NF_SAI_PED_VD.CD_FILIAL	= @CD_FILIAL 
			AND EST_NF_SAI_PED_VD.CD_NF		= @CD_NF

		------------------------------------------------------------------------------------------------------------
		PRINT 'Deletando vinculo de nota fiscal de entrada com o pedido vinculado a nota de saida'
		------------------------------------------------------------------------------------------------------------
		DELETE D
		FROM EST_NF_ENT_EST_PED_VD D
		WHERE 	
			D.CD_EMP		= @CD_EMP 
			AND D.CD_FILIAL	= @CD_FILIAL 
			AND D.CD_PED	= @RS_CD_PED							

		------------------------------------------------------------------------------------------------------------
		PRINT 'Voltando a quantidade devolvida da nota fiscal de entrada'
		------------------------------------------------------------------------------------------------------------
		UPDATE DEV_IT SET
			QTDE_PROD_DEVO_GERADA = (QTDE_PROD_DEVO_GERADA - QT_IT)
		FROM EST_NF_ENT_IT_DEVOLUCAO DEV_IT
			INNER JOIN EST_NF_SAI_IT SAI_IT ON 
				DEV_IT.CD_EMP			= SAI_IT.CD_EMP
				AND DEV_IT.CD_FILIAL	= SAI_IT.CD_FILIAL
				AND DEV_IT.CD_PROD		= SAI_IT.CD_PROD
		WHERE 
			SAI_IT.CD_EMP			= @CD_EMP
			AND SAI_IT.CD_FILIAL	= @CD_FILIAL
			AND SAI_IT.CD_NF		= @CD_NF
			AND DEV_IT.CD_NF		= @RS_CD_NF_ENT
			
				
		------------------------------------------------------------------------------------------------------------
		PRINT 'Voltando a quantidade do estoque por lote'
		------------------------------------------------------------------------------------------------------------
		UPDATE CPL_LOTE SET
			QTDE_PROD = (CPL_LOTE.QTDE_PROD + SAI_LOTE.QTDE_PROD)
		FROM EST_PROD_CPL_LOTE CPL_LOTE
			INNER JOIN EST_NF_SAI_IT_EST_PROD_CPL_LOTE SAI_LOTE ON 
				CPL_LOTE.CD_EMP			= SAI_LOTE.CD_EMP
				AND CPL_LOTE.CD_FILIAL	= SAI_LOTE.CD_FILIAL
				AND CPL_LOTE.CD_LOTE	= SAI_LOTE.CD_LOTE
		WHERE 
			SAI_LOTE.CD_EMP			= @CD_EMP
			AND SAI_LOTE.CD_FILIAL	= @CD_FILIAL
			AND SAI_LOTE.CD_NF		= @CD_NF
			
				
		------------------------------------------------------------------------------------------------------------
		PRINT 'Voltando o controle do icms retido'
		------------------------------------------------------------------------------------------------------------
		DECLARE RS_TEMP_ST CURSOR FAST_FORWARD FOR 
			SELECT  NF_DEB.CD_PROD, NF_DEB.CD_IT, DEB.CD_CTR, 
					DEB_CRED.CD_CTR_CRED, DEB.QT_IT
			FROM EST_NF_SAI_IT_EST_PROD_CPL_TRIB_ST_DEB NF_DEB
				INNER JOIN EST_PROD_CPL_TRIB_ST_DEB DEB ON 
					NF_DEB.CD_CTR = DEB.CD_CTR
				INNER JOIN EST_PROD_CPL_TRIB_ST_DEB_EST_PROD_CPL_TRIB_ST_CRED DEB_CRED ON 
					DEB_CRED.CD_CTR = DEB.CD_CTR    
			WHERE 
				NF_DEB.CD_EMP			= @CD_EMP
				AND NF_DEB.CD_FILIAL	= @CD_FILIAL
				AND NF_DEB.CD_NF		= @CD_NF;


		OPEN RS_TEMP_ST
		FETCH NEXT FROM RS_TEMP_ST INTO @RS_CD_PROD, @RS_CD_IT, @RS_CD_CTR_DEB, @RS_CD_CTR_CRED, @RS_QT_IT
			WHILE @@FETCH_STATUS=0
				BEGIN
					--------------------------------------------------------------------------------------------
					PRINT 'Repondo o saldo do credito do icms ST'
					--------------------------------------------------------------------------------------------
					UPDATE T SET 
						QT_IT_SLD = QT_IT_SLD + @RS_QT_IT 
					FROM EST_PROD_CPL_TRIB_ST_CRED T
					WHERE 
						T.CD_CTR = @RS_CD_CTR_CRED
					
					--------------------------------------------------------------------------------------------
					PRINT 'Removendo vinculo do icms ST debito com a nota fiscal'
					--------------------------------------------------------------------------------------------
					DELETE D 
					FROM EST_NF_SAI_IT_EST_PROD_CPL_TRIB_ST_DEB D
					WHERE				
						D.CD_EMP		= @CD_EMP 
						AND D.CD_FILIAL	= @CD_FILIAL 
						AND D.CD_NF		= @CD_NF
						AND D.CD_PROD	= @RS_CD_PROD
						AND D.CD_IT		= @RS_CD_IT	
					
					--------------------------------------------------------------------------------------------
					PRINT 'Repondo o saldo do credito do icms ST'
					--------------------------------------------------------------------------------------------	
					DELETE D
					FROM EST_PROD_CPL_TRIB_ST_DEB D
					WHERE 
						D.CD_CTR = @RS_CD_CTR_DEB
						
					FETCH NEXT FROM RS_TEMP_ST INTO @RS_CD_PROD, @RS_CD_IT, @RS_CD_CTR_DEB, @RS_CD_CTR_CRED, @RS_QT_IT			
				END
				
		CLOSE RS_TEMP_ST	      
		DEALLOCATE RS_TEMP_ST
		    

		------------------------------------------------------------------------------------------------------------
		PRINT 'Cancelando duplicatas do contas a receber'
		------------------------------------------------------------------------------------------------------------
		DECLARE RS_TEMP_REC CURSOR FAST_FORWARD FOR 
		SELECT	RC_DEB.CD_RC_DEB, 		
				(SELECT TOP 1 RC_CRED.CD_DP_LANC
				 FROM RC_CRED
				 WHERE  RC_CRED.CD_EMP			= RC_DEB.CD_EMP
						AND RC_CRED.CD_FILIAL	= RC_DEB.CD_FILIAL
						AND RC_CRED.CD_RC_DEB	= RC_DEB.CD_RC_DEB) AS CD_DP_LANC
		FROM 
			RC_DEB_DUP_NR_CTR 
			INNER JOIN RC_DEB ON
				RC_DEB_DUP_NR_CTR.CD_EMP	= RC_DEB.CD_EMP AND 
				RC_DEB_DUP_NR_CTR.CD_FILIAL = RC_DEB.CD_FILIAL AND
				RC_DEB_DUP_NR_CTR.NR_DP		= RC_DEB.NR_DP AND 
				RC_DEB_DUP_NR_CTR.ANO		= RC_DEB.ANO
			INNER JOIN RC_DEB_EST_NF_SAI ON
				RC_DEB_DUP_NR_CTR.CD_EMP	= RC_DEB_EST_NF_SAI.CD_EMP AND
				RC_DEB_DUP_NR_CTR.CD_FILIAL = RC_DEB_EST_NF_SAI.CD_FILIAL AND 
				RC_DEB_DUP_NR_CTR.NR_DP		= RC_DEB_EST_NF_SAI.NR_DP AND
				RC_DEB_DUP_NR_CTR.ANO		= RC_DEB_EST_NF_SAI.ANO 
		WHERE       
			RC_DEB_EST_NF_SAI.CD_EMP		= @CD_EMP
			AND RC_DEB_EST_NF_SAI.CD_FILIAL	= @CD_FILIAL
			AND RC_DEB_EST_NF_SAI.CD_NF		= @CD_NF

		OPEN RS_TEMP_REC
		FETCH NEXT FROM RS_TEMP_REC INTO @RS_CD_RC_DEB, @RS_CD_DP_LANC
			WHILE @@FETCH_STATUS=0
				BEGIN
					------------------------------------------------------------------------------------------------------------
					PRINT 'Verificando se existe pagamento para a duplicada, caso exista aborta o cancelamento.'
					------------------------------------------------------------------------------------------------------------
					IF @RS_CD_DP_LANC <> 0 
						BEGIN	
							RAISERROR ('Nota fiscal com duplicatas baixadas. Cancelamento nao permitido',999,1);
							RETURN
						END
					
					------------------------------------------------------------------------------------------------------------
					PRINT 'Marcando duplicata como cancelada'
					------------------------------------------------------------------------------------------------------------					
					UPDATE T SET 
						STS_NF = 1, 
						STS_DP = 3
					FROM RC_DEB T 
					WHERE T.CD_EMP		= @CD_EMP
						AND T.CD_FILIAL = @CD_FILIAL
						AND T.CD_RC_DEB = @RS_CD_RC_DEB
					
					FETCH NEXT FROM RS_TEMP_REC INTO @RS_CD_RC_DEB, @RS_CD_DP_LANC
				END
		
		CLOSE RS_TEMP_REC			
		DEALLOCATE RS_TEMP_REC


		------------------------------------------------------------------------------------------------------------
		PRINT 'Marcando duplicata como cancelada'
		------------------------------------------------------------------------------------------------------------
		DECLARE RS_TEMP_PAG CURSOR FAST_FORWARD FOR 
		SELECT T.CD_PG_CRED, T.CD_DP_LANC
		FROM PG_DEB_EST_NF_SAI T
		WHERE T.CD_EMP			= @CD_EMP
				AND T.CD_FILIAL	= @CD_FILIAL
				AND T.CD_NF		= @CD_NF

		OPEN RS_TEMP_PAG
		FETCH NEXT FROM RS_TEMP_PAG INTO @RS_CD_PG_CRED, @RS_CD_DP_LANC
			WHILE @@FETCH_STATUS=0
				BEGIN
					------------------------------------------------------------------------------------------------------------
					PRINT 'Removendo vinculo da duplicada com a nota fiscal'
					------------------------------------------------------------------------------------------------------------					
					DELETE T
					FROM PG_DEB_EST_NF_SAI T
					WHERE T.CD_EMP			= @CD_EMP
							AND T.CD_FILIAL	= @CD_FILIAL
							AND T.CD_NF		= @CD_NF				

					------------------------------------------------------------------------------------------------------------
					PRINT 'Identificando valor do titulo e saldo previsto com o retorno da baixa'
					------------------------------------------------------------------------------------------------------------
					SELECT  										
							@RS_SLD_DUP	   = (PG_CRED.VLR_DESP_OUTR	+ PG_CRED.VLR_DP), 
							@RS_SLD_BX	   = (PG_CRED.SLD_DP		+ PG_DEB.VL_PGTO)
					FROM PG_DEB, PG_CRED
					WHERE
						PG_DEB.CD_EMP			= PG_CRED.CD_EMP 
						AND PG_DEB.CD_FILIAL	= PG_CRED.CD_FILIAL 
						AND PG_DEB.CD_PG_CRED	= PG_CRED.CD_PG_CRED 
						AND PG_DEB.CD_EMP		= @CD_EMP 
						AND PG_DEB.CD_FILIAL	= @CD_FILIAL 
						AND PG_DEB.CD_PG_CRED	= @RS_CD_PG_CRED        
						AND PG_DEB.CD_DP_LANC	= @RS_CD_DP_LANC  

					IF @RS_CD_PG_CRED > 0 AND @RS_SLD_BX > 0				
						BEGIN
							------------------------------------------------------------------------------------------------------------
							PRINT 'Deletando o registro da baixa'
							------------------------------------------------------------------------------------------------------------
							DELETE D
							FROM PG_DEB D
							WHERE	D.CD_EMP			= @CD_EMP
									AND D.CD_FILIAL		= @CD_FILIAL
									AND D.CD_PG_CRED	= @RS_CD_PG_CRED
									AND D.CD_DP_LANC	= @RS_CD_DP_LANC
						
							------------------------------------------------------------------------------------------------------------
							PRINT 'Alterando o status e saldo do titulo'
							------------------------------------------------------------------------------------------------------------
							UPDATE T SET						
								STS_DP	= (CASE WHEN @RS_SLD_DUP <> @RS_SLD_BX THEN 2 ELSE 0 END),
								SLD_DP  =  SLD_DP + @RS_SLD_BX						
							FROM PG_CRED T
							WHERE 
								T.CD_EMP			= @CD_EMP
								AND T.CD_FILIAL		= @CD_FILIAL 
								AND T.CD_PG_CRED	= @RS_CD_PG_CRED
						END
						
					FETCH NEXT FROM RS_TEMP_PAG INTO @RS_CD_PG_CRED, @RS_CD_DP_LANC
				END				
						
		CLOSE RS_TEMP_PAG
		DEALLOCATE RS_TEMP_PAG

		------------------------------------------------------------------------------------------------------------
		PRINT 'Identificando valores para estorno da conta correndo fornecedor'
		------------------------------------------------------------------------------------------------------------
		SELECT 
			@RS_VLR_NF			= EST_NF_SAI.VLR_NF,
			@RS_CD_CRED_FORN	= PG_CRED_FORN_EST_NF_SAI.CD_CRED_FORN,    
			@RS_VLR_CRED		= PG_CRED_FORN.VLR_CRED
		FROM 
			EST_NF_SAI 
			INNER JOIN PG_CRED_FORN_EST_NF_SAI ON
				EST_NF_SAI.CD_EMP				= PG_CRED_FORN_EST_NF_SAI.CD_EMP
				AND EST_NF_SAI.CD_FILIAL		= PG_CRED_FORN_EST_NF_SAI.CD_FILIAL
				AND EST_NF_SAI.CD_NF			= PG_CRED_FORN_EST_NF_SAI.CD_NF
			INNER JOIN PG_CRED_FORN ON    
				PG_CRED_FORN.CD_EMP				= PG_CRED_FORN_EST_NF_SAI.CD_EMP
				AND PG_CRED_FORN.CD_CRED_FORN	= PG_CRED_FORN_EST_NF_SAI.CD_CRED_FORN	
		WHERE 
			EST_NF_SAI.CD_EMP			= @CD_EMP
			AND EST_NF_SAI.CD_FILIAL	= @CD_FILIAL
			AND EST_NF_SAI.CD_NF		= @CD_NF
		    

		IF @RS_VLR_NF > 0 
			BEGIN	
				------------------------------------------------------------------------------------------------------------
				PRINT 'Removendo vinculo da nota fiscal com o credito no fornecedor'
				------------------------------------------------------------------------------------------------------------
				DELETE T
				FROM PG_CRED_FORN_EST_NF_SAI T
				WHERE 
					T.CD_EMP		= @CD_EMP 
					AND T.CD_FILIAL = @CD_FILIAL
					AND T.CD_NF		= @CD_NF 
				
				------------------------------------------------------------------------------------------------------------
				PRINT 'Alterando o valor do credito com o fornecedor'
				------------------------------------------------------------------------------------------------------------	
				IF @RS_VLR_CRED > @RS_VLR_NF 
					BEGIN 
						UPDATE T SET 
							VLR_CRED = (VLR_CRED - @RS_VLR_NF)
						FROM PG_CRED_FORN T 
						WHERE 
							T.CD_EMP = @CD_EMP
							AND T.CD_CRED_FORN = @RS_CD_CRED_FORN
					END			 
				ELSE
					BEGIN 
						DELETE D 
						FROM PG_CRED_FORN D
						WHERE 
							D.CD_EMP			= @CD_EMP
							AND D.CD_CRED_FORN	= @RS_CD_CRED_FORN
					END
					
			END    
			

	------------------------------------------------------------------------------------------------------------
	PRINT 'Marcando a nota fiscal como pendencia que nao sera solucionada'
	------------------------------------------------------------------------------------------------------------
	UPDATE T SET 
		PEND_SOLUC = 2
	FROM EST_NF_SAI_NFE_PEND T 
	WHERE 
		T.CD_EMP			= @CD_EMP
		AND T.CD_FILIAL		= @CD_FILIAL
		AND T.CD_NF			= @CD_NF
		AND T.PEND_SOLUC	= 1						
		
	------------------------------------------------------------------------------------------------------------
	PRINT 'Deletando pendcia de cancelamento automatico.'
	------------------------------------------------------------------------------------------------------------		
	DELETE D
	FROM EST_NF_SAI_CANCEL_PEND D
	WHERE 
		D.CD_EMP		= @CD_EMP		
		AND D.CD_FILIAL = @CD_FILIAL 
		AND D.CD_NF		= @CD_NF 
		
	COMMIT TRANSACTION 
	
END	TRY
BEGIN CATCH
	ROLLBACK TRANSACTION 
	
	DECLARE @ErrorMessage NVARCHAR(4000);
    DECLARE @ErrorSeverity INT;
    DECLARE @ErrorState INT;

    SELECT 
        @ErrorMessage = ERROR_MESSAGE(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE();
    
    RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
END CATCH 	